% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalVar.R
\name{normalVar}
\alias{normalVar}
\title{Compute variance of truncated normal}
\usage{
normalVar(cutoff, truncMean = NULL, mean = 0, sd = 1)
}
\arguments{
\item{cutoff}{The cutoff value for the truncated normal}

\item{truncMean}{The mean of the truncated normal. If left NULL, it will be estimated.}

\item{mean}{The mean of the non-truncated distribution (defaults to zero)}

\item{sd}{The sd of the non-truncated distribution (defaults to 1)}
}
\value{
the variance of the tuncated normal distribution
}
\description{
Given a particular cutoff (\code{x}), what is the variance of the new truncated normal?
}
\details{
The variance of a pdf (f(x)) is computed by integrating the function x^2*f(x) from -Inf to Inf. To compute
a truncated normal, the function remains the same, but the limits change (from -Inf to \code{cutoff}).
}
\examples{
### compute variance of a distribution cutoff at zero
normalVar(1)
### compare to simulated data
x = rnorm(10000000, 0, 1)
var(x[x>1])
}
\author{
Dustin Fife
}

