% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compression.R
\name{compress}
\alias{compress}
\title{Compresses a data matrix based on mutual information (segregation)}
\usage{
compress(
  data,
  group,
  unit,
  weight = NULL,
  neighbors = "local",
  n_neighbors = 50,
  max_iter = Inf
)
}
\arguments{
\item{data}{A data frame.}

\item{group}{A categorical variable
contained in \code{data}. Defines the first dimension
over which segregation is computed.}

\item{unit}{A categorical variable
contained in \code{data}. Defines the second dimension
over which segregation is computed.}

\item{weight}{Numeric. Only frequency weights are allowed.
(Default \code{NULL})}

\item{neighbors}{Either a data frame or a character. If data frame, then
it needs exactly two columns, where each row identifies
a set of "neighbors" that may be merged.
If "local", considers the \code{n_neighbors} closest neighbors
in terms of local segregation.
If "all", all units are considered as possible neighbors. This
may be very time-consuming.}

\item{n_neighbors}{Only relevant if \code{neighbors} is \code{"local"}.}

\item{max_iter}{Maximum number of iterations (Default \code{Inf})}
}
\value{
Returns a data.table.
}
\description{
Given a data set that identifies suitable neighbors for merging,
this function will merge units iteratively, where in each iteration
the neighbors with the smallest reduction in terms of total M will be merged.
}
