% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segmetric.R
\name{plot}
\alias{plot}
\alias{plot.segmetric}
\title{Plot function}
\usage{
\method{plot}{segmetric}(
  x,
  type = "base",
  ...,
  title = NULL,
  background = "#FAFAFA",
  layers = c("ref_sf", "seg_sf"),
  ref_color = "#FF00009F",
  ref_fill = "#FFFFFF00",
  ref_label = "reference",
  ref_size = 2,
  ref_symbol = 2,
  seg_color = "#0000009F",
  seg_fill = "#FFFFFF00",
  seg_label = "segment",
  seg_size = 1,
  seg_symbol = 3,
  selected_fill = "#9A9AFF50",
  plot_centroids = TRUE,
  centroids_color = "#000000FF",
  centroids_label = "centroid",
  subset_id = NULL,
  subset_color = "#FFFFFF00",
  subset_fill = "#F0E4167F",
  metric_id = NULL,
  break_style = "jenks",
  plot_extent = NULL,
  plot_legend = TRUE,
  plot_axes = TRUE
)
}
\arguments{
\item{x}{A \code{segmetric} object.}

\item{type}{A \code{character}. Either \code{"base"}, \code{"subset"}, or \code{"choropleth"}.}

\item{...}{Ignored.}

\item{title}{A \code{character} with plot title}

\item{background}{A \code{character} with a valid hexadecimal color in \code{rgb} or
\code{rgba} format. Set the map background color.}

\item{layers}{A \code{character}. One or both of \code{"ref_sf"} and \code{"seg_sf"}
(works only for \code{type = "base"} and \code{type = "subset"}).}

\item{ref_color, seg_color, ref_fill, seg_fill}{A \code{character} with a
valid hexadecimal color in \code{rgb} or \code{rgba} format. Set the border and fill
colors for reference and segmentation polygons.}

\item{ref_label, seg_label, centroids_label}{A \code{character} with legend
labels for reference polygons, segmentation polygons, and centroids.}

\item{ref_size, seg_size}{A \code{numeric}. Set symbol's size for centroids.}

\item{ref_symbol, seg_symbol}{An \code{integer}. Symbol to represent polygons'
centroids (see \code{pch} param in \link[graphics]{points}).}

\item{selected_fill}{A \code{character} with a valid hexadecimal color in \code{rgb}
or \code{rgba} format. Set the fill color of selected reference or
segmentation polygons depending on \code{subset_id}.}

\item{plot_centroids}{A \code{logical}. Plot centroids or not.}

\item{centroids_color}{A \code{character} with a valid hexadecimal color
in \code{rgb} or \code{rgba} format. Set the border colors for centroids.}

\item{subset_id}{A \code{character} with subset name
(required for \code{type = "subset"})}

\item{subset_color, subset_fill}{A \code{character} with a valid hexadecimal
color in \code{rgb} or \code{rgba} format. Set the border and fill
colors for subset polygons (works only with \code{type = "subset"}).}

\item{metric_id}{A \code{character} with metric to be plotted in choropleth maps
(required for \code{type = "choropleth"})}

\item{break_style}{A \code{character} with the name of a method to compute
the intervals for choropleth maps. Can be one of \code{"sd"}, \code{"equal"},
\code{"pretty"}, \code{"quantile"}, \code{"kmeans"}, \code{"hclust"}, \code{"bclust"}, \code{"fisher"},
\code{"jenks"}, \code{"dpih"}, and \code{"headtails"} (see \code{style} parameter in
\link[classInt]{classIntervals}).}

\item{plot_extent}{A \code{sf} object. Set the map extent for a plot.}

\item{plot_legend}{A \code{logical}. Plot legend or not.}

\item{plot_axes}{A \code{logical}. Plot coordinates axis or not.}
}
\description{
Plot a segmetric map according to the parameter \code{type}:
\itemize{
\item \code{"base"}: simple plot of the reference or segmentation polygons;
\item \code{"subset"}: plot polygons from a subset over the base plot;
\item \code{"choropleth"}: plot a choropleth map from polygons of a subset using
metric values.
}
}
