% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tximport.R
\name{tximport}
\alias{tximport}
\title{Run tximport on RNA-seq quantifications}
\usage{
tximport(
  inputDir,
  tx2gene,
  samples = NULL,
  outputDir = "data",
  type = c("salmon", "kallisto"),
  countsFromAbundance = "lengthScaledTPM",
  ignoreTxVersion = TRUE,
  ...
)
}
\arguments{
\item{inputDir}{Directory that contains the quantification directories.}

\item{tx2gene}{\code{NULL} or data.frame of mapping between transcripts and
genes, as returned by \code{\link[=getTx2gene]{getTx2gene()}}, passed to \code{\link[tximport:tximport]{tximport::tximport()}}.}

\item{samples}{Names of quantification directories to include. \code{NULL}
indicates all.}

\item{outputDir}{Directory in which to save the result, a file named
"tximport_output.qs", using \code{\link[qs:qsave]{qs::qsave()}}. If \code{NULL}, no file is saved.}

\item{type}{Passed to \code{\link[tximport:tximport]{tximport::tximport()}}.}

\item{countsFromAbundance}{Passed to \code{\link[tximport:tximport]{tximport::tximport()}}.}

\item{ignoreTxVersion}{Passed to \code{\link[tximport:tximport]{tximport::tximport()}}.}

\item{...}{Additional arguments passed to \code{\link[tximport:tximport]{tximport::tximport()}}.}
}
\value{
A list, as returned by \code{\link[tximport:tximport]{tximport::tximport()}}, invisibly.
}
\description{
This function uses the
\href{https://doi.org/doi:10.18129/B9.bioc.tximport}{tximport package}.
}
