% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calib.functions.R
\name{ProxyConversion}
\alias{ProxyConversion}
\title{Convert between Temperature in Degrees C and Proxy Units}
\usage{
ProxyConversion(
  temperature = NULL,
  proxy.value = NULL,
  calibration.type = "identity",
  slp.int.means = NULL,
  slp.int.vcov = NULL,
  calibration = switch(calibration.type, identity = NA, Uk37 = "Mueller global", MgCa =
    "Ten planktonic species_350-500"),
  point.or.sample = c("point", "sample"),
  n = 1
)
}
\arguments{
\item{temperature}{Temperature in degrees C}

\item{proxy.value}{Temperature in proxy units}

\item{calibration.type}{Type of proxy, e.g. Uk37 or MgCa}

\item{slp.int.means}{Optional user supplied vector of values for the slope
and intercept of the calibration function. Overides the defaults.}

\item{slp.int.vcov}{Optional user supplied variance covariance matrix
calibration parameters. Overides the defaults.}

\item{calibration}{The name of a specific calibration for which calibration parameters
are provided by sedproxy. Currently applies only to calibration.type MgCa.}

\item{point.or.sample}{Use the "best estimate" calibration parameters, or
parameters sampled from the fitted calibration model}

\item{n}{the number of replicate conversions to make in the case of sampled
calibration parameters}
}
\value{
a vector of temperatures or proxy values
}
\description{
A wrapper function for accessing proxy - temperature conversion functions
}
\details{
Valid entries for calibration are: "Ten planktonic species_350-500", "G. aequilateralis_350-500", "G.
  aequilateralis_500-1000", "G. conglobatus_350-500", "G. hirsuta_350-500",
  "G. inflata_350-500", "G. ruber pink_250-350", "G. ruber pink_350-500", "G.
  ruber white_250-350", "G. ruber white_350-500", "G. sacculifer with
  sac_350-500", "G. sacculifer without sac_350-500", "G.
  truncatulinoides_350-500", "G. truncatulinoides_500-1000", "N.
  dutertrei_350-500", "O. univesa_350-500", "P. obliquiloculata_350-500"
}
\examples{
# From temperature to UK'37
## With fixed calibration
ProxyConversion(temperature = c(10, 20), point.or.sample = "point",
                calibration.type = "Uk37")

## With random calibration, 5 replicates
ProxyConversion(temperature = c(1, 2), n = 5, point.or.sample = "sample",
                calibration.type = "Uk37")


## Back-transformation with same calibration
ProxyConversion(
  proxy.value = as.vector(
    ProxyConversion(
      temperature = c(21, 22),
      calibration.type = "Uk37",
      point.or.sample = "point"
    )
  ),
  point.or.sample = "point",
  calibration.type = "Uk37"
)

## Back-transformation with random calibration
ProxyConversion(
  proxy.value = as.vector(
    ProxyConversion(
      temperature = c(21, 22),
      calibration.type = "Uk37",
     point.or.sample = "point"
    )
  )
  ,
  n = 5,
  point.or.sample = "sample",
  calibration.type = "Uk37"
)

## Incompatible arguments
\dontrun{
ProxyConversion(temperature = 1, proxy.value = 1)
}
}
\concept{calib}
