% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_export_options.R
\name{check_export_options}
\alias{check_export_options}
\title{Returns deviations from suggested export options}
\usage{
check_export_options(dat)
}
\arguments{
\item{dat}{\code{secuTrialdata} object}
}
\description{
Given a \code{secuTrialdata} object, this function returns information on deviations
from suggested export options.
}
\details{
While the package strives to allow loading of as many types of secuTrial data exports
         as possible, there are certain export options which are less likely to cause issues.
         If possible it is suggested to export data which adheres to a suggested option set.
         This function points out deviations from the suggested set of options which are: \cr
         is_zip == TRUE \cr
         refvals_separate == TRUE \cr
         add_id == TRUE \cr
         duplicate_meta == FALSE \cr
         encoding == "UTF-8" \cr
         form_status == TRUE \cr
         centre_info == TRUE \cr
         proj_setup == TRUE \cr
         dict_items$lang == "en" \cr
         hidden_fields == FALSE \cr
         structure == TRUE
}
\examples{
path <- system.file("extdata", "sT_exports", "exp_opt",
                    "s_export_CSV-xls_CTU05_only_column_names.zip",
                    package = "secuTrialR")
sT_export <- read_secuTrial_raw(path)

secuTrialR:::check_export_options(sT_export)
}
