% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visit_structure.R
\name{visit_structure}
\alias{visit_structure}
\alias{plot.secuTrialvisit}
\title{Get the visit structure of \code{secuTrialdata} objects}
\usage{
visit_structure(x, sorted = TRUE)

\method{plot}{secuTrialvisit}(x, ...)
}
\arguments{
\item{x}{a \code{secuTrialdata} object}

\item{sorted}{logical if TRUE sorted by first visit}

\item{...}{further parameters}
}
\value{
data.frame with 1 for whether a form (rows) was collected during a particular visit (columns)

plot of the visit plan
}
\description{
Get the visit structure of \code{secuTrialdata} objects
}
\note{
Requires a fixed visit structure - an error will be returned for projects without
      a visit structure or one with flexible visits
}
\examples{
export_location <- system.file("extdata", "sT_exports", "lnames",
                               "s_export_CSV-xls_CTU05_long_ref_miss_en_utf8.zip",
                               package = "secuTrialR")
# read all export data
sT_export <- read_secuTrial(data_dir = export_location)
# get visit structure
vs <- visit_structure(sT_export)
# plot
plot(vs)
}
