% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMonth.R
\name{plotMonth}
\alias{plotMonth}
\title{Plot Results by Month}
\usage{
plotMonth(data, resp, panels = 12, ...)
}
\arguments{
\item{data}{a data frame.}

\item{resp}{response variable to plot.}

\item{panels}{number of panels to use in plot (1 or 12). 12 gives one panel
per month, 1 plots all the months in the same panel.}

\item{\dots}{further arguments passed to or from other methods.}
}
\description{
Plots results by month.
}
\details{
Assumes the data frame contains variables called year and month.
}
\examples{
\donttest{
data(CVD)
plotMonth(data=CVD, resp='cvd', panels=12)
}

}
\references{
Barnett, A.G., Dobson, A.J. (2010) \emph{Analysing Seasonal
Health Data}. Springer.
}
\author{
Adrian Barnett \email{a.barnett@qut.edu.au}
}
