% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search-functions.R
\name{search_site}
\alias{search_site}
\alias{search_google}
\alias{search_bing}
\alias{search_duckduckgo}
\alias{search_ddg}
\alias{search_ixquick}
\alias{search_startpage}
\alias{search_sp}
\alias{search_stackoverflow}
\alias{search_so}
\alias{search_rstudio_community}
\alias{search_rscom}
\alias{search_github}
\alias{search_gh}
\alias{search_bitbucket}
\alias{search_bb}
\title{Search a Query on a Search Portal in a Web Browser}
\usage{
search_site(query, site = c("google", "bing", "duckduckgo", "ddg",
  "startpage", "sp", "stackoverflow", "so", "rstudio community", "rscom",
  "github", "gh", "bitbucket", "bb"), rlang = TRUE)

search_google(query = geterrmessage(), rlang = TRUE)

search_bing(query = geterrmessage(), rlang = TRUE)

search_duckduckgo(query = geterrmessage(), rlang = TRUE)

search_ddg(query = geterrmessage(), rlang = TRUE)

search_ixquick(query = geterrmessage(), rlang = TRUE)

search_startpage(query = geterrmessage(), rlang = TRUE)

search_sp(query = geterrmessage(), rlang = TRUE)

search_stackoverflow(query = geterrmessage(), rlang = TRUE)

search_so(query = geterrmessage(), rlang = TRUE)

search_rstudio_community(query = geterrmessage(), rlang = TRUE)

search_rscom(query = geterrmessage(), rlang = TRUE)

search_github(query = geterrmessage(), rlang = TRUE)

search_gh(query = geterrmessage(), rlang = TRUE)

search_bitbucket(query = geterrmessage(), rlang = TRUE)

search_bb(query = geterrmessage(), rlang = TRUE)
}
\arguments{
\item{query}{Contents of string to search. Default is the error message.}

\item{site}{Name of site to search on. Supported options:
\code{"google"} (default), \code{"bing"}, \code{"duckduckgo"}, \code{"startpage"},
\code{"stackoverflow"}, \code{"rstudio community"}, \code{"github"}, and
\code{"bitbucket"}.}

\item{rlang}{Search for results written in R. Default is \code{TRUE}}
}
\value{
The generated search URL or an empty string.
}
\description{
Creates an appropriate query string for a search engine and then opens
up the resulting page in a web browser.
}
\section{Google Search}{

The \code{search_google} function searches \href{https://google.com}{Google} using:
\code{https://google.com/search?q=<query>}

See \url{https://moz.com/blog/the-ultimate-guide-to-the-google-search-parameters}
for details.
}

\section{Bing Search}{

The \code{search_bing()} function searches \href{https://bing.com}{Bing} using:
\code{https://bing.com/search?q=<query>}
}

\section{DuckDuckGo Search}{

The \code{search_duckduckgo()} and \code{search_ddg()} functions both search
\href{https://duckduckgo.com}{DuckDuckGo} using: \code{https://duckduckgo.com/?q=<query>}
}

\section{Startpage Search}{

The \code{search_startpage()} function searches
\href{https://startpage.com}{startpage} using:
\code{https://startpage.com/do/dsearch?query=<query>}

For additional details regarding \href{https://startpage.com}{startpage}'s
search interface please see:
\url{https://support.startpage.com/index.php?/Knowledgebase/Article/View/1261/0/add-familystartpagecom-as-the-default-search-engine-in-chrome}
}

\section{StackOverflow Search}{

The \code{search_stackoverflow()} and \code{search_so()} functions both search
\href{https://stackoverflow.com}{StackOverflow} using:
\code{https://stackoverflow.com/search?q=\%5Br\%5D+<query>}

For additional details regarding \href{https://stackoverflow.com}{StackOverflow}'s
search interface please see:
\url{https://stackoverflow.com/help/advanced-search-parameters-jobs}
}

\section{RStudio Community Search}{

The \code{search_rstudio_community()} and \code{search_rscom()} functions both search
\href{https://community.rstudio.com/}{RStudio Community} using:
\code{https://community.rstudio.com/search?q=<query>}

For additional details regarding \href{https://community.rstudio.com/}{RStudio Community}'s
search interface please see the \href{https://discourse.org}{Discourse} API documentation:
\url{https://docs.discourse.org/#tag/Search}
}

\section{GitHub Search}{

The \code{search_github()} and \code{search_gh()} functions both search
\href{https://github.com}{GitHub} using:
\code{https://github.com/search?q=<query>+language\%3Ar+type\%3Aissue&type=Issues}

For additional details regarding \href{https://github.com}{GitHub}'s
search interface please see:
\url{https://help.github.com/categories/searching-for-information-on-github/}
and \url{https://help.github.com/articles/searching-code/}
}

\section{BitBucket Search}{

The \code{search_bitbucket()} and \code{search_bb()} functions both search
\href{https://bitbucket.com}{BitBucket} using:
\code{https://bitbucket.com/search?q=lang\%3Ar+<query>}

For additional details regarding \href{https://bitbucket.com}{BitBucket}'s
search interface please see:
\url{https://confluence.atlassian.com/bitbucket/code-search-in-bitbucket-873876782.html}
}

\examples{
# Search in a generic way
search_site("r-project", "google")

# Search Google
search_google("r-project")

# Search Bing
search_bing("Microsoft R")

# Search DuckDuckGo
search_duckduckgo("R language")

# Search startpage
search_startpage("RStudio IDE")

# Search StackOverflow for Convolutions in the r tag
search_stackoverflow("convolutions")

# Search all languages on StackOverflow for convolutions
search_stackoverflow("convolutions", rlang = FALSE)

# Search RStudio Community
search_rstudio_community("RStudio IDE")

# Search GitHub Issues for bivariate normal in the language:r
search_github("bivariate normal")

# Search all languages on GitHub Issues for bivariate normal
search_github("bivariate normal", rlang = FALSE)

# Search BitBucket for assertions
search_bitbucket("assertions")

\dontrun{
# On error, automatically search the message on google
options(error = searcher("google"))
options(error = search_google)
}
}
\seealso{
\code{\link[=search_google]{search_google()}}, \code{\link[=search_bing]{search_bing()}}, \code{\link[=search_duckduckgo]{search_duckduckgo()}},
\code{\link[=search_startpage]{search_startpage()}}, \code{\link[=search_stackoverflow]{search_stackoverflow()}}, \code{\link[=search_rstudio_community]{search_rstudio_community()}},
\code{\link[=search_github]{search_github()}}, \code{\link[=search_bitbucket]{search_bitbucket()}}, and \code{\link[=searcher]{searcher()}}
}
