% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ct.R
\name{read_ct_spec}
\alias{read_ct_spec}
\title{Read in a controlled terminology}
\usage{
read_ct_spec(file = cli::cli_abort("`file` must be specified"))
}
\arguments{
\item{file}{A path to a file containing a controlled terminology
specification data set. The following are expected of this file:
\itemize{
\item The file is expected to be a CSV file;
\item The file is expected to contain a first row of column names;
\item This minimal set of variables is expected: codelist_code, collected_value, term_synonyms, and term_value.
}}
}
\value{
A \link[tibble:tibble-package]{tibble} with a controlled terminology
specification.
}
\description{
\code{\link[=read_ct_spec]{read_ct_spec()}} imports a controlled terminology specification data set as a
\link[tibble:tibble-package]{tibble}.
}
\examples{
# Get the local path to one of the controlled terminology example files.
path <- ct_spec_example("ct-01-cm")

# Import it to R.
read_ct_spec(file = path)

}
