% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expectedPairwiseAllocationMatrix.R
\name{expectedPairwiseAllocationMatrix}
\alias{expectedPairwiseAllocationMatrix}
\title{Compute Expected Pairwise Allocation Matrix}
\usage{
expectedPairwiseAllocationMatrix(x)
}
\arguments{
\item{x}{A
collection of clusterings as a
\code{B}-by-\code{n} matrix, each of the \code{B} rows represents a
clustering of \code{n} items using cluster labels.  For clustering
\code{b}, items \code{i} and \code{j} are in the same cluster if
\code{x[b,i] == x[b,j]}.}
}
\value{
A \code{n}-by-\code{n} symmetric matrix whose \code{(i,j)} elements
gives the estimated expected number of times that items \code{i} and
\code{j} are in the same subset (i.e, cluster) based on the
frequencies from the supplied clusterings.
}
\description{
This function computes the \code{n}-by-\code{n} matrix whose \code{(i,j)}
element gives the (estimated) expected number of times that \code{i} and
\code{j} are in the same subset (i.e, cluster).
This is the (estimated) probability that items are clustered together.
These estimates are based on the frequencies from the supplied,
randomly-sampled clusterings.
}
\examples{
suppressWarnings({  # For testing purposes, suppress deprecation warning.

probabilities <- expectedPairwiseAllocationMatrix(iris.clusterings)

})

}
\seealso{
\code{\link{dlso}}, \code{\link{salso}}
}
\author{
David B. Dahl \email{dahl@stat.byu.edu}
}
