% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list.R
\name{list_layers_future}
\alias{list_layers_future}
\title{List the future climate layers provided by one or more datasets}
\usage{
list_layers_future(datasets=c(), scenario=NA, year=NA,
  terrestrial=TRUE, marine=TRUE, monthly=TRUE, version=NULL)
}
\arguments{
\item{datasets}{character vector. Code of the datasets.}

\item{scenario}{character vector. Climate change scenario, e.g. \code{"B1", 
"A1B", "A2"}.}

\item{year}{integer. Year for which you want the climate change prediction, 
e.g. \code{2100, 2200}.}

\item{terrestrial}{logical. When \code{TRUE} (default), then datasets that 
only have terrestrial data (seamasked) are returned.}

\item{marine}{logical. When \code{TRUE} (default), then datasets that only 
have marine data (landmasked) are returned.}

\item{monthly}{logical. When \code{FALSE}, then no monthly layers are 
returned. All annual and monthly layers are returned by default.}

\item{version}{numeric vector. When \code{NULL} then layers from all versions
of datasets are returned (default) else layers are filtered by version
number.}
}
\value{
A dataframe with information on the supported future climate layers.
}
\description{
\code{list_layers_future} returns information on the future climate layers of
one or more datasets.
}
\details{
By default it returns all layers from all datasets, when both marine
  and terrestrial are \code{FALSE} then only layers without land- nor 
  seamasks are returned.
}
\examples{
# list the first 5 layers
list_layers_future()[1:5,]
# list layer codes for Bio-ORACLE with scenario B1 and year 2100
list_layers_future("Bio-ORACLE", scenario = "B1", year = 2100)$layer_code
}
\seealso{
\code{\link{list_layers}}, \code{\link{list_layers_paleo}}, 
  \code{\link{list_datasets}}, \code{\link{load_layers}}
}

