% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmb-sim.R
\name{dharma_residuals}
\alias{dharma_residuals}
\title{DHARMa residuals}
\usage{
dharma_residuals(simulated_response, object, plot = TRUE, ...)
}
\arguments{
\item{simulated_response}{Output from \code{\link[=simulate.sdmTMB]{simulate.sdmTMB()}}.}

\item{object}{Output from \code{\link[=sdmTMB]{sdmTMB()}}.}

\item{plot}{Logical.}

\item{...}{Other arguments to pass to \code{\link[DHARMa:createDHARMa]{DHARMa::createDHARMa()}}.}
}
\value{
A data frame of observed and expected values is invisibly returned,
so you can set \code{plot = FALSE} and assign the output to an object if you wish
to plot the residuals yourself. See the examples.
}
\description{
Plot (and possibly return) DHARMa residuals. This is a wrapper function
around \code{\link[DHARMa:createDHARMa]{DHARMa::createDHARMa()}} to facilitate its use with \code{\link[=sdmTMB]{sdmTMB()}} models.
\strong{Note}: simulation testing suggests that these DHARMa residuals can suggest
problems with model fit even with properly specified models presumably due to
the Laplace approximation and/or spatially correlated random effects.
Consider the slower \code{\link[=residuals.sdmTMB]{residuals.sdmTMB()}} with \code{type = "mle-mcmc"}.
}
\examples{
if (inla_installed()) {
fit <- sdmTMB(density ~ as.factor(year) + s(depth, k = 3),
  data = pcod_2011, time = "year", mesh = pcod_mesh_2011,
  family = tweedie(link = "log"), spatial = "off",
  spatiotemporal = "off")

# The `simulated_response` argument is first so the output from
# simulate() can be piped to dharma_residuals():
# simulate(fit, nsim = 500) \%>\% dharma_residuals(fit)

s <- simulate(fit, nsim = 500)
dharma_residuals(s, fit)
r <- dharma_residuals(s, fit, plot = FALSE)
head(r)
plot(r$expected, r$observed)
abline(a = 0, b = 1)
}
}
\seealso{
\code{\link[=simulate.sdmTMB]{simulate.sdmTMB()}}, \code{\link[=residuals.sdmTMB]{residuals.sdmTMB()}}
}
