% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{linesTorus3d}
\alias{linesTorus3d}
\title{Lines and arrows with wrapping in the torus}
\usage{
linesTorus3d(x, y, z, col = 1, arrows = FALSE, ...)
}
\arguments{
\item{x, y}{vectors with horizontal coordinates, wrapped in \eqn{[-\pi,\pi)}.}

\item{z}{vector with vertical coordinates, wrapped in \eqn{[-\pi,\pi)}.}

\item{col}{color vector of length \code{1} or the same length of \code{x}, \code{y}, and \code{z}.}

\item{arrows}{flag for drawing arrows instead of line segments.}

\item{...}{further graphical parameters passed to \code{\link[graphics]{segments}} or \code{\link[graphics]{arrows}}.}
}
\value{
Nothing. The functions are called for drawing wrapped lines.
}
\description{
Joins the corresponding points with line segments or arrows that exhibit wrapping in \eqn{[-\pi,\pi)} in the horizontal and vertical axes.
}
\details{
\code{x}, \code{y}, and \code{z} are wrapped to \eqn{[-\pi,\pi)} before plotting. \code{arrows = TRUE} makes sequential calls to \code{\link[rgl]{arrow3d}}, and is substantially slower than \code{arrows = FALSE}.
}
\examples{
\donttest{
if (requireNamespace("rgl")) {
  n <- 20
  x <- toPiInt(rnorm(n, mean = seq(-pi, pi, l = n), sd = 0.5))
  y <- toPiInt(rnorm(n, mean = seq(-pi, pi, l = n), sd = 0.5))
  z <- toPiInt(x + y + rnorm(n, mean = seq(-pi, pi, l = n), sd = 0.5))
  rgl::plot3d(x, y, z, xlim = c(-pi, pi), ylim = c(-pi, pi),
              zlim = c(-pi, pi), col = rainbow(n), size = 2,
              box = FALSE, axes = FALSE)
  linesTorus3d(x = x, y = y, z = z, col = rainbow(n), lwd = 2)
  torusAxis3d()
  rgl::plot3d(x, y, z, xlim = c(-pi, pi), ylim = c(-pi, pi),
              zlim = c(-pi, pi), col = rainbow(n), size = 2,
              box = FALSE, axes = FALSE)
  linesTorus3d(x = x, y = y, z = z, col = rainbow(n), ltyCross = 2,
               arrows = TRUE, theta = 0.1 * pi / 180, barblen = 0.1)
  torusAxis3d()
}
}
}
