% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdc_extreme.R
\name{sdc_extreme}
\alias{sdc_extreme}
\title{Calculate RDC rule-compliant extreme values}
\usage{
sdc_extreme(
  data,
  id_var,
  val_var,
  by = NULL,
  n_min = getOption("sdc.n_ids", 5L),
  n_max = n_min
)
}
\arguments{
\item{data}{\link{data.frame} from which the descriptive statistics are
calculated.}

\item{id_var}{\link{character} The name of the id variable.}

\item{val_var}{\link{character} vector of value variables on which descriptive
statistics are computed.}

\item{by}{Grouping variables (or expression) as in \link{data.table}'s \code{by}.}

\item{n_min}{\link{integer} The number of values used to calculate the minimum, by
default 5.}

\item{n_max}{\link{integer} The number of values used to calculate the maximum, by
default 5.}
}
\value{
A list \link{list} of class \code{sdc_extreme} with detailed information about
options, settings and the calculated extreme values (if possible).
}
\description{
Checks if calculation of extreme values comply to RDC rules. If
so, function returns average min and max values according to RDC rules.
}
\examples{
sdc_extreme(data = sdc_extreme_DT, id_var = "id", val_var = "val_1")
sdc_extreme(data = sdc_extreme_DT, id_var = "id", val_var = "val_2")
sdc_extreme(data = sdc_extreme_DT, id_var = "id", val_var = "val_2",
            n_min = 7)
sdc_extreme(data = sdc_extreme_DT, id_var = "id", val_var = "val_3",
            n_min = 10, n_max = 10)
sdc_extreme(data = sdc_extreme_DT, id_var = "id", val_var = "val_3",
            n_min = 8, n_max = 8)
sdc_extreme(data = sdc_extreme_DT, id_var = "id", val_var = "val_1",
            by = year)
sdc_extreme(data = sdc_extreme_DT, id_var = "id", val_var = "val_1",
            by = c("sector", "year"))
}
