% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/julia_setup.R
\name{julia_status}
\alias{julia_status}
\title{Check status of Julia installation and environment}
\usage{
julia_status(verbose = TRUE)
}
\arguments{
\item{verbose}{If TRUE, print detailed status information. Defaults to TRUE.}
}
\value{
A list with components:
\item{julia_found}{Logical. TRUE if Julia installation found.}
\item{julia_path}{Character. Path to Julia bin, or "" if not found.}
\item{julia_version}{Character. Julia version string, or "" if not found.}
\item{env_exists}{Logical. TRUE if Project.toml exists in sdbuildR package, which specifies the Julia packages and versions needed to instantiate the Julia environment for sdbuildR.}
\item{env_instantiated}{Logical. TRUE if Manifest.toml exists (i.e., Julia environment was instantiated).}
\item{status}{Character. Overall status: "julia_not_installed", "julia_needs_update", "sdbuildR_needs_reinstall", "install_julia_env", "ready", or "unknown".}
}
\description{
Check if Julia can be found and if the Julia environment for sdbuildR has been instantiated. Note that this does not mean a Julia session has been started, merely whether it \emph{could} be. For more guidance, please see \href{https://kcevers.github.io/sdbuildR/articles/julia-setup.html}{this vignette}.
}
\section{What to Do Next}{

Based on the 'status' value:
\describe{
\item{"julia_not_installed"}{Install Julia from \url{https://julialang.org/install/}}
\item{"julia_needs_update"}{Update Julia to >= version 1.10}
\item{"install_julia_env"}{Run \code{install_julia_env()}}
\item{"ready"}{Run \code{use_julia()} to start a session}
}
}

\examples{
status <- julia_status()
print(status)

}
\concept{julia}
