% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwise-comparisons.R
\name{permutation_test}
\alias{permutation_test}
\title{Simple permutation test}
\usage{
permutation_test(
  scores1,
  scores2,
  n_permutation = 999,
  one_sided = FALSE,
  comparison_mode = c("difference", "ratio")
)
}
\arguments{
\item{scores1}{Vector of scores to compare against another vector of scores.}

\item{scores2}{A second vector of scores to compare against the first}

\item{n_permutation}{The number of replications to use for a permutation
test. More replications yield more exact results, but require more
computation.}

\item{one_sided}{Whether or not to compute a one-sided test. Default is
\code{FALSE}.}

\item{comparison_mode}{How to compute the test statistic for the comparison
of the two scores. Should be either "difference" or "ratio".}
}
\value{
p-value of the permutation test
}
\description{
The implementation of the permutation test follows the
function
\code{permutationTest} from the \code{surveillance} package by Michael Höhle,
Andrea Riebler and Michaela Paul.
The function compares two vectors of scores. It computes the mean of each
vector independently and then takes either the difference or the ratio of
the two. This observed difference or ratio is compared against the same
test statistic based on permutations of the original data.

Used in \code{\link[=get_pairwise_comparisons]{get_pairwise_comparisons()}}.
}
\keyword{internal}
