% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivoting_functions.R
\name{sample_to_range}
\alias{sample_to_range}
\title{Change Data from a Sample Based Format to a Interval Range Format}
\usage{
sample_to_range(data, range = c(0, 50, 90), type = 7, keep_quantile_col = TRUE)
}
\arguments{
\item{data}{a data.frame with samples}

\item{range}{a numeric vector of interval ranges to extract
(e.g. \code{c(0, 50, 90)})}

\item{type}{type argument passed down to the quantile function. For more
information, see \code{\link{quantile}}}

\item{keep_quantile_col}{keep quantile column, default is TRUE}
}
\value{
a data.frame in a long interval range format
}
\description{
Transform data from a format that is based on predictive samples to a format
based on interval ranges
}
\examples{
example_data <- scoringutils::integer_example_data

quantile_data <- sample_to_range(example_data)

}
