#' Binary Example Data
#'
#' A toy dataset for a probability forecast of a binary outcome variable
#'
#' @format A data.table with 60 rows and 4 variables:
#' \describe{
#'   \item{id}{unique identifier for true observed values}
#'   \item{true_values}{true observed values}
#'   \item{model}{name of the model that generated the forecasts}
#'   \item{predictions}{predicted probability that the corresponding true
#'   value will be 1}
#' }

"binary_example_data"


#' Continuous Example Data
#'
#' A toy dataset for a probabilistic forecast of a continuous outcome variable
#'
#' @format A data frame with 3000 rows and 5 variables:
#' \describe{
#'   \item{id}{unique identifier for true observed values}
#'   \item{model}{name of the model that generated the forecasts}
#'   \item{true_values}{true observed values}
#'   \item{sample}{number that identifies the predictive sample generated by
#'   a specific model for a specific observed value}
#'   \item{predictions}{predictive sample for the corresponding true
#'   value}
#' }
"continuous_example_data"


#' Integer Example Data
#'
#' A toy dataset for a probabilistic forecast of an integer outcome variable
#'
#' @format A data frame with 3000 rows and 5 variables:
#' \describe{
#'   \item{id}{unique identifier for true observed values}
#'   \item{model}{name of the model that generated the forecasts}
#'   \item{true_values}{true observed values}
#'   \item{sample}{number that identifies the predictive sample generated by
#'   a specific model for a specific observed value}
#'   \item{predictions}{predictive sample for the corresponding true
#'   value}
#' }
"integer_example_data"

#' Quantile Example Data
#'
#' A toy dataset for quantile forecasts of an outcome variable
#'
#' @format A data frame with 60 rows and 9 variables:
#' \describe{
#'   \item{true_values}{true observed values}
#'   \item{id}{unique identifier for true observed values}
#'   \item{model}{name of the model that generated the forecasts}
#'   \item{lower_90}{prediction for the lower value of the 90\% interval range
#'   (corresponding to the 5\% quantile)}
#'   \item{lower_50}{prediction for the lower value of the 50\% interval range
#'   (corresponding to the 25\% quantile)}
#'   \item{lower_0}{prediction for the lower value of the 0\% interval range
#'   (corresponding to the 50\% quantile, i.e. the median. For computational
#'   reasons there need be a column with \code{lower_0} and \code{upper_0})}
#'   \item{upper_0}{prediction for the upper value of the 0% interval range
#'   (corresponding to the 50\% quantile, i.e. the median)}
#'   \item{upper_50}{prediction for the upper value of the 50\% interval range
#'   (corresponding to the 75\% quantile)}
#'   \item{upper_90}{prediction for the lower value of the 90\% interval range
#'   (corresponding to the 95\% quantile)}
#' }
"quantile_example_data"


