% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augmentation.R
\name{augmentation}
\alias{augmentation}
\title{Augmentation}
\usage{
augmentation(xf, xnf, yf)
}
\arguments{
\item{xf}{The matrix of financed clients' characteristics to be used in the scorecard.}

\item{xnf}{The matrix of not financed clients' characteristics to be used in the scorecard (must be the same features in the same order as xf!).}

\item{yf}{The matrix of financed clients' labels}
}
\value{
List containing the model using financed clients only and the model produced using the Augmentation method.
}
\description{
This function performs Reject Inference using the Augmentation technique. Note that this technique is theoretically better than using the financed clients scorecard in the MAR and misspecified model case.
}
\details{
This function performs the Augmentation method on the data. When provided with labeled observations \eqn{(x^\ell,y)}, it first fits the logistic regression model \eqn{p_\theta} of
\eqn{x^\ell} on \eqn{y}, then reweighs labeled observations according to their probability of being sampled, i.e. calculates the predicted probabilities of \eqn{p_\theta} on all observations, defines score-bands and calculates, in each of these score-bands, the probability of having been accepted as the proportion of labeled samples in that score-band.
It then refits a logistic regression model \eqn{p_\eta} on the labeled samples.
}
\examples{
# We simulate data from financed clients
xf <- matrix(runif(100 * 2), nrow = 100, ncol = 2)
theta <- c(2, -2)
log_odd <- apply(xf, 1, function(row) theta \%*\% row)
yf <- rbinom(100, 1, 1 / (1 + exp(-log_odd)))
# We simulate data from not financed clients (MCAR mechanism)
xnf <- matrix(runif(100 * 2), nrow = 100, ncol = 2)
augmentation(xf, xnf, yf)
}
\references{
Enea, M. (2015), speedglm: Fitting Linear and Generalized Linear Models to Large Data Sets, \url{https://CRAN.R-project.org/package=speedglm}
Ehrhardt, A., Biernacki, C., Vandewalle, V., Heinrich, P. and Beben, S. (2018), Reject Inference Methods in Credit Scoring: a rational review,
}
\seealso{
\code{glm}, \code{speedglm}
}
\author{
Adrien Ehrhardt
}
\keyword{credit}
\keyword{inference}
\keyword{reject}
\keyword{réintégration}
\keyword{scorecard}
\keyword{scoring}
