% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_df.R
\name{split_df}
\alias{split_df}
\title{Split a dataset}
\usage{
split_df(dt, y = NULL, ratio = c(0.7, 0.3), seed = 618, no_dfs = 2,
  name_dfs = c("train", "test"))
}
\arguments{
\item{dt}{A data frame.}

\item{y}{Name of y variable, Defaults to NULL. The input data will split based on the predictor y, if it is provide.}

\item{ratio}{A numeric value, Defaults to 0.7. It indicates the ratio of total rows contained in one split, must less than 1.}

\item{seed}{A random seed, Defaults to 618.}

\item{no_dfs}{Number of returned data frames. Defaults to 2.}

\item{name_dfs}{Name of returned data frames. If its length is not equal with no_dfs, then the names will setted as 'dX'. Defaults to train and test.}
}
\value{
A list of data frames
}
\description{
Split a dataset into train and test
}
\examples{
# load German credit data
data(germancredit)

# Example I
dt_list = split_df(germancredit, y="creditability")
train = dt_list[[1]]
test = dt_list[[2]]

# dimensions of train and test datasets
lapply(dt_list, dim)


# Example II
dt_list2 = split_df(germancredit, y="creditability", ratio = c(0.5, 0.2))
lapply(dt_list2, dim)

}
