% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scorecard.R
\name{scorecard_ply}
\alias{scorecard_ply}
\title{Application of Scorecard}
\usage{
scorecard_ply(dt, card, only_total_score = TRUE, print_step = 1L)
}
\arguments{
\item{dt}{Original data}

\item{card}{Scorecard generated from \code{scorecard}.}

\item{only_total_score}{A logical value. Default is TRUE, which means only total credit score is return. Otherwise, if it is FALSE, which means both total credit score and score points of each variables are return.}

\item{print_step}{A non-negative integer. Default is 1. Print variable names by print_step when print_step>0. If print_step=0, no message is printed.}
}
\value{
Credit score
}
\description{
\code{scorecard_ply} calculates credit score using the results of \code{scorecard}.
}
\examples{
library(data.table)
library(scorecard)

# load germancredit data
data("germancredit")

# select only 5 x variables and rename creditability as y
dt <- setDT(germancredit)[, c(1:5, 21)][, `:=`(
  y = ifelse(creditability == "bad", 1, 0),
  creditability = NULL
)]

# woe binning ------
bins <- woebin(dt, "y")
dt_woe <- woebin_ply(dt, bins)

# glm ------
m <- glm( y ~ ., family = "binomial", data = dt_woe)
# summary(m)

\dontrun{
# Select a formula-based model by AIC
m_step <- step(m, direction="both", trace=FALSE)
m <- eval(m_step$call)
# summary(m)

# predicted proability
# dt_woe$pred <- predict(m, type='response', dt_woe)

# performace
# ks & roc plot
# perf_eva(dt_woe$y, dt_woe$pred)
}

# scorecard
# Example I # creat a scorecard
card <- scorecard(bins, m)

# credit score
# Example I # only total score
score1 <- scorecard_ply(dt, card)

\dontrun{
# Example II # credit score for both total and each variable
score2 <- scorecard_ply(dt, card, only_total_score = F)
}
}
\seealso{
\code{\link{scorecard}}
}
