% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/data_manipulation.R
\name{booleanMatrix}
\alias{booleanMatrix}
\title{Creation of boolean matrices for highlighting results}
\usage{
booleanMatrix(data, find = "max", th = 0, by = "row")
}
\arguments{
\item{data}{It can be a data frame, a matrix or a vector.}

\item{find}{A string indicating what has to be detected. Possible values are:
\itemize{
  \item{\code{'eq'}}{ All values equal to the value passed in \code{th}}
  \item{\code{'le'}}{ All values lower or equal to the value passed in \code{th}}
  \item{\code{'ge'}}{ All values greater or equal to the value passed in \code{th}}
  \item{\code{'lw'}}{ All values lower than the value passed in \code{th}}
  \item{\code{'gt'}}{ All values greater than the value passed in \code{th}}
  \item{\code{'min'}}{ Minimum value in each row / column / matrix}
  \item{\code{'max'}}{ Maximum value in each row / column / matrix}
}}

\item{th}{Thershold used when \code{find} is set to \code{'eq'}, \code{'ge'}, \code{'le'}, \code{'gt'} or \code{'lw'}.}

\item{by}{A string or string vector indicating where the min/max values have to be find. It can be \code{'row'}, \code{'col'} or \code{'mat'} for the row, column and matrix min/max respectively.}
}
\value{
A boolean matrix that matches in dimension the output data and where the identified elements are marked as TRUE.
}
\description{
A simple function to create boolean matrices to be used when constructing LaTeX tables.
}
\examples{
data('data_gh_2008')
booleanMatrix(data.gh.2008, find='min', by='row')
booleanMatrix(data.gh.2008, find='ge',  th=0.5)
}

