% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.ijdata.R
\name{read.ijdata}
\alias{read.ijdata}
\title{Read ImageJ zip file containing several ROI files and extract coordinate information.}
\usage{
read.ijdata(X, spots = "point", gbs = "polyline", main = "line",
  names = "generate.invalid", spot.names = NULL, gbs.names = NULL,
  main.name = "main", sample.name = "file", scale = 1, unit = NULL)
}
\arguments{
\item{X}{character string defining the name (including extension) or file path of an ImageJ zip file. Alternatively an \code{\link[=read.ijzip]{ijzip}} object.}

\item{spots}{optional. A character argument specifying the type of ROI objects that should be considered as sample spot sequences. Alternatively a numeric vector specifying the order of elements or a character vector specifying the names of ROI objects that should be assigned as sampling spot sequences. Defaults to \code{"point"} (See "Details" for further information).}

\item{gbs}{optional. A character argument, numeric vector or character vector specifying the type of ROI objects that should be considered as growth bands. Defauls to \code{"polyline"}. f left empty the remaining elements that are not defined in holes and main are assumed to be growth lines. For further information see \code{spots} and "Details". At the moment \code{spots} must be specified for this option to work.}

\item{main}{optional. A character argument specifying the type of ROI object that should be considered as the measurement axis. Only one measurement axis per ImageJ .zip file is allowed. Defaults to \code{"line"}.  At the moment \code{spots} must be specified for this option to work.}

\item{names}{optional. A character argument specifying how the names of \code{spots} and \code{gbs} should be generated. These names will be used in further functions (\code{\link{convert.ijdata}}, \code{\link{spot.dist}}). In general, it is adviced to use simple ROI names without special characters (for example \code{-} is not allowed in a ROI name; see 'Details'). Possible \code{names} options are:
\itemize{
\item \code{"generate.invalid"} (default). Uses the ROI object names, except when they are not valid \code{\link{data.frame}} column names. In the latter case sequential names will be generated.  
\item \code{"generate"}. Generates sequential names for all elements.
\item \code{"keep"}. Uses the ROI object names, except when they are not valid \code{\link{data.frame}} column names. In the latter case \code{\link{make.names}} function will be used to generate \code{data.frame} combatible column names.
\item \code{"force.keep"}. Uses the ROI object names as they are in the .zip file. Using this option might cause problems in consequent functions and is not recommended.
\item \code{"manual"}. Names for both \code{spots} and \code{gbs} are searched from \code{spot.names} and \code{gbs.names} arguments, respectively. 
\item \code{"manual.spots"}. Names for \code{spots} are searched from \code{spot.names} argument. Names for \code{gbs} are generated following \code{"generate.invalid"}.
 \item \code{"manual.gbs"}. Names for \code{gbs} are searched from \code{gbs.names} argument. Names for \code{spots} are generated following \code{"generate.invalid"}.
}}

\item{spot.names}{optional. A character vector of equal length to \code{spots} defining the names of sample spot sequences. Required if \code{names = "manual"} or \code{"manual.spots"}. Ignored otherwise.}

\item{gbs.names}{optional. A character vector of equal length to \code{gbs} defining the names of growth bands. Required if \code{names = "manual"} or \code{"manual.gbs"}. Ignored otherwise.}

\item{main.name}{optional. A character vector of lenght 1 defining the name of the measurement axis (\code{main}). If \code{main.name = "keep"}, the ROI object name will be used (not recommended, see "Details"). Otherwise the name will be taken from the argument. Defaults to \code{"main"}.}

\item{sample.name}{optional. A character vector of length 1 defining the name of the sample. File name without the extension or alternatively \code{ijzip} object name is used as a default (\code{sample.name = "file"}).}

\item{scale}{optional. A numeric value defining the scale of photograph in pixels / \code{unit}. Defaults to 1.}

\item{unit}{optional. A charater vector of length 1 defining the unit of measurements. See \code{scale}.}
}
\value{
Returns an "IJDATA" object, which is a list of data frames containing the x and y coordinates for sampling spot sequences (\code{spots.x} and \code{spots.y}), growth bands (\code{gbs.x} and \code{gbs.y}), and measurement axis (\code{main.x} and \code{main.y}) together with sample name, scaling factor and unit of measurement.
}
\description{
A wrapper function, which reads an ImageJ zip file containing a collection of ROI files and outputs a list of data frames ready for \code{\link{convert.ijdata}} function.
}
\details{
In order to minimize the amount of text to be typed by a user, ROI objects of type "point" (this includes the "Multi-point Tool" points) are considered as sample spot sequences (\code{spots}) by default. Further, all "polyline" objects are assumed as growth bands (\code{gbs}) and "line" objects as the measurement axis (\code{main}) resulting to that only one "line" object is allowed per .zip file using the default settings. Alternatively, the user can specify the \code{spots}, \code{gbs}, and \code{main} objects manually using the order of the ImageJ .zip file with the exception that \bold{only one measurement axis is allowed} per \code{\link[=convert.ijdata]{rawDist}} or \code{\link[=spot.dist]{spotDist}} object. 

Punctuation characters other than \code{_} or \code{.} should not be used as names of \code{spots} or \code{gbs}, because they tend to confuse the internal \code{\link[base]{grep}} functions in \code{\link{spot.dist}} function. Hence it is adviced to use one of the options renaming invalid names of \code{spots} and \code{gbs} (\code{"generate.invalid"}, \code{"generate"}, \code{"keep"}).
}
\examples{
# Locate the example zip file
path <- file.path(system.file("extdata", package = "sclero"), "shellspots.zip") 

# You can replace 'path' by 'Your_file_name.zip'
dat <- read.ijdata(path) 
summary(dat)

## Works also for IJZIP objects
dat2 <- read.ijzip(path)
dat2 <- read.ijdata(dat2)
dat[!(dat \%in\% dat2)] # Only the sample name differs
}
\author{
Mikko Vihtakari
}
\seealso{
\code{\link{order.ijdata}} for ordering and subsetting \code{read.ijdata} output.

\code{\link{convert.ijdata}} for converting the coordinate information to \link[spatstat]{spatstat} point patterns. 

\code{\link{spot.dist}} for aligning sample spot sequences. 

\code{\link[RImageJROI]{read.ijroi}} and \code{\link[RImageJROI]{read.ijzip}} for reading ImageJ ROI and .zip files.
}

