% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{as.scidb}
\alias{as.scidb}
\title{Upload R data to SciDB}
\usage{
as.scidb(db, x, name, start, gc = TRUE, ...)
}
\arguments{
\item{db}{a scidb database connection returned from \code{\link{scidbconnect}}}

\item{x}{an R data frame, raw value, Matrix, matrix, or vector object}

\item{name}{a SciDB array name to use}

\item{start}{starting SciDB integer coordinate index (does not apply to data frames)}

\item{gc}{set to FALSE to disconnect the SciDB array from R's garbage collector}

\item{...}{other options, see \code{\link{df2scidb}}}
}
\value{
A \code{scidb} object
}
\description{
Upload R data to SciDB
}
\note{
Supported R objects include data frames, scalars, vectors, dense matrices,
and double-precision sparse matrices of class CsparseMatrix. Supported R scalar
types and their resulting SciDB types are:
 \itemize{
 \item{integer   -> }{int32}
 \item{logical   -> }{int32}
 \item{character -> }{string}
 \item{double    -> }{double}
 \item{integer64 -> }{int64}
 \item{raw       -> }{binary}
 \item{Date      -> }{datetime}
}
R factor values are converted to their corresponding character levels.
}
\seealso{
\code{\link{as.R}}
}

