% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ird.R
\name{ird}
\alias{ird}
\alias{print.sc_ird}
\title{IRD - Improvement rate difference}
\usage{
ird(data, dvar, pvar, decreasing = FALSE, phases = c(1, 2))

\method{print}{sc_ird}(x, digits = 3, ...)
}
\arguments{
\item{data}{A single-case data frame. See \code{\link[=scdf]{scdf()}} to learn about this
format.}

\item{dvar}{Character string with the name of the dependent variable.
Defaults to the attributes in the scdf file.}

\item{pvar}{Character string with the name of the phase variable. Defaults to
the attributes in the scdf file.}

\item{decreasing}{If you expect data to be lower in the B phase, set
\code{decreasing = TRUE}. Default is \code{decreasing = FALSE}.}

\item{phases}{A vector of two characters or numbers indicating the two phases
that should be compared. E.g., \code{phases = c("A","C")} or \code{phases = c(2,4)}
for comparing the second to the fourth phase. Phases could be combined by
providing a list with two elements. E.g., \code{phases = list(A = c(1,3), B = c(2,4))} will compare phases 1 and 3 (as A) against 2 and 4 (as B). Default
is \code{phases = c(1,2)}.}

\item{x}{An object returned by \code{\link[=ird]{ird()}}}

\item{digits}{The minimum number of significant digits to be use.}

\item{...}{Further arguments passed to the function.}
}
\description{
\code{ird()} calculates the robust improvement rate difference as proposed by
Parker and colleagues (2011).
}
\details{
The adaptation of the improvement rate difference for single-case phase
comparisons was developed by Parker and colleagues (2009). A variation called
robust improvement rate difference was proposed by Parker and colleagues in
2011. This function calculates the robust improvement rate difference. It
follows the formula suggested by Pustejovsky (2019). For a multiple case
design, ird is based on the overall improvement rate of all cases which is
the average of the irds for each case.
}
\section{Functions}{
\itemize{
\item \code{print(sc_ird)}: Print results

}}
\references{
Parker, R. I., Vannest, K. J., & Brown, L. (2009). The
improvement rate difference for single-case research. Exceptional Children,
75(2), 135-150.

Parker, R. I., Vannest, K. J., & Davis, J. L. (2011). Effect Size in
Single-Case Research: A Review of Nine Nonoverlap Techniques. Behavior
Modification, 35(4), 303-322. https://doi.org/10.1177/0145445511399147

Pustejovsky, J. E. (2019). Procedural sensitivities of effect sizes for
single-case designs with directly observed behavioral outcome measures.
\emph{Psychological Methods}, \emph{24(2)}, 217-235.
https://doi.org/10.1037/met0000179
}
