% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCALPEL_helper.R
\name{getY}
\alias{getY}
\title{Read in Y matrix for SCALPEL.}
\usage{
getY(scalpelOutput, videoType = "processed", part = NULL)
}
\arguments{
\item{scalpelOutput}{An object returned by one of the SCALPEL functions:
\code{\link{scalpel}}, \code{\link{scalpelStep0}}, \code{\link{scalpelStep1}}, \code{\link{scalpelStep2}}, or \code{\link{scalpelStep3}}.}

\item{videoType}{Specify whether to read in the processed data from Step 0 (default; \code{videoType="processed"}) or raw data (\code{videoType="raw"}).}

\item{part}{The part of the video to read in, if it is split across multiple files. The default is NULL, which means that all parts will be read in and combined.}
}
\value{
An object of class \code{scalpelY} that can be provided as the \code{Y} argument in \code{\link{plotFrame}},
\code{\link{plotVideoVariance}}, \code{\link{plotBrightest}}, \code{\link{plotThresholdedFrame}}, and \code{\link{plotCandidateFrame}}.
If would like to call these functions many times, this avoids reading the video into memory repeatedly.
}
\description{
This step allows the user to read in Y, the matrix of raw or processed video data, to use with several plotting functions.
}
\examples{
\dontrun{
### many of the functions in this package are interconnected so the
### easiest way to learn to use the package is by working through the vignette,
### which is available at ajpete.com/software

#assumes you have run the example for the "scalpel" function
#read in the raw data
rawY = getY(scalpelOutput = scalpelOutput, videoType = "raw")
#read in the processed data from Step 0
processedY = getY(scalpelOutput = scalpelOutput, videoType = "processed")
}
}
