% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans-date.r
\name{time_trans}
\alias{time_trans}
\title{Transformation for date-times (class POSIXt)}
\usage{
time_trans(tz = NULL)
}
\arguments{
\item{tz}{Optionally supply the time zone.  If \code{NULL}, the default,
the time zone will be extracted from first input with a non-null tz.}
}
\description{
Transformation for date-times (class POSIXt)
}
\examples{
hours <- seq(ISOdate(2000,3,20, tz = ""), by = "hour", length.out = 10)
t <- time_trans()
t$transform(hours)
t$inverse(t$transform(hours))
t$format(t$breaks(range(hours)))
}
