% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{plotOntoTree}
\alias{plotOntoTree}
\title{Plot a tree representation of ontology terms}
\usage{
plotOntoTree(
  ont,
  onts,
  plot_ancestors = TRUE,
  ont_query = NULL,
  roots = c("CL:0000548"),
  ...
)
}
\arguments{
\item{ont}{ontology object}

\item{onts}{ontology ids to plot}

\item{plot_ancestors}{if plot ancestors or not}

\item{ont_query}{query ontology to highlight in the tree}

\item{roots}{root ontology in tree, default "animal cells" in cell ontology}

\item{...}{additional parameters for ontologyPlot::onto_plot}
}
\value{
an ontology tree plot
}
\description{
Plot a tree representation of ontology terms
}
\examples{
\dontrun{
plotOntoTree(ont = ont, onts = c("CL:0000066", "CL:0000082"), ont_query = c("CL:0000082"))
}
}
