% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/form_tensor.R
\name{get_ctype_vargenes}
\alias{get_ctype_vargenes}
\title{Partition main gene by cell matrix into per cell type matrices with significantly
variable genes only. Generally, this should be done through calling the
form_tensor() wrapper function.}
\usage{
get_ctype_vargenes(
  container,
  method,
  thresh,
  ncores = container$experiment_params$ncores,
  seed = container$experiment_params$rand_seed
)
}
\arguments{
\item{container}{environment Project container that stores sub-containers
for each cell type as well as results and plots from all analyses}

\item{method}{character The method used to select significantly variable
genes across donors within a cell type. Can be either "anova" to use basic
anova with cells grouped by donor or "norm_var" to get the top overdispersed
genes by normalized variance. Set to "norm_var_pvals" to use normalized variance
p-values as calculated in pagoda2.}

\item{thresh}{numeric A pvalue threshold to use for gene significance when
method is set to "anova" or "empir". For the method "norm_var" thresh is the
number of top overdispersed genes from each cell type to include.}

\item{ncores}{numeric The number of cores to use (default=container$experiment_params$ncores)}

\item{seed}{numeric Seed passed to set.seed() (default=container$experiment_params$rand_seed)}
}
\value{
The project container with pseudobulk matrices limted to the selected 
most variable genes.
}
\description{
Partition main gene by cell matrix into per cell type matrices with significantly
variable genes only. Generally, this should be done through calling the
form_tensor() wrapper function.
}
