% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function.R
\name{plotCellTypeCorrHeatmap}
\alias{plotCellTypeCorrHeatmap}
\title{plot clustered heatmap for cell type corr}
\usage{
plotCellTypeCorrHeatmap(corr_matrix, scale = NA, ...)
}
\arguments{
\item{corr_matrix}{correlation matrix from cellTypeGOCorr or crossSpeciesCellTypeGOCorr}

\item{scale}{scale value by column, row, or default no scaling (NA)}

\item{...}{params to pass to slanter::sheatmap}
}
\value{
a sheatmap heatmap
}
\description{
plot clustered heatmap for cell type corr
}
\examples{
\donttest{
library(scGOclust)
library(httr)
httr::set_config(httr::config(ssl_verifypeer = FALSE))
mmu_tbl = ensemblToGo(species = 'mmusculus')
data(mmu_subset)

go_seurat_obj = makeGOSeurat(ensembl_to_GO = mmu_tbl,
 seurat_obj = mmu_subset,
 feature_type = "external_gene_name")

cell_type_go = getCellTypeGO(go_seurat_obj = go_seurat_obj, cell_type_co = "cell_type_annotation")

corr_matrix = cellTypeGOCorr(cell_type_go = cell_type_go, corr_method = "pearson")

plotCellTypeCorrHeatmap(corr_matrix = corr_matrix, scale = "column")

}
}
