% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function.R
\name{analyzeGOSeurat}
\alias{analyzeGOSeurat}
\title{standard seurat analysis on GO_seurat object}
\usage{
analyzeGOSeurat(
  go_seurat_obj,
  cell_type_col,
  scale.factor = 10000,
  nfeatures = 2000,
  cluster_res = 1,
  min.dist = 0.3,
  ...
)
}
\arguments{
\item{go_seurat_obj}{go seurat object created by makeGOSeurat}

\item{cell_type_col}{column name in mera.data storing cell type classes}

\item{scale.factor}{param for Seurat NormalizeData}

\item{nfeatures}{param for Seurat FindVariableFeatures}

\item{cluster_res}{resolution for Seurat FindClusters}

\item{min.dist}{param for Seurat RunUMAP}

\item{...}{additional params for all Seurat functions involved in this function}
}
\value{
standard analyzed GO seurat object until UMAP
}
\description{
standard seurat analysis on GO_seurat object
}
\examples{
\donttest{
library(scGOclust)
library(httr)
httr::set_config(httr::config(ssl_verifypeer = FALSE))
mmu_tbl = ensemblToGo(species = 'mmusculus')
data(mmu_subset)
go_seurat_obj = makeGOSeurat(ensembl_to_GO = mmu_tbl,
 seurat_obj = mmu_subset,
 feature_type = "external_gene_name")

analyzeGOSeurat(go_seurat_obj = go_seurat_obj, cell_type_col = "cell_type_annotation")
}
}
