% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plotting_Utilities.R
\name{Move_Legend}
\alias{Move_Legend}
\title{Move Legend Position}
\usage{
Move_Legend(position = "right", ...)
}
\arguments{
\item{position}{valid position to move legend.  Default is "right".}

\item{...}{extra arguments passed to \code{ggplot2::theme()}.}
}
\value{
Returns a list-like object of class \emph{theme}.
}
\description{
Shortcut for thematic modification to move legend position.
}
\examples{
# Generate a plot and customize theme
library(ggplot2)
df <- data.frame(x = rnorm(n = 100, mean = 20, sd = 2), y = rbinom(n = 100, size = 100, prob = 0.2))
p <- ggplot(data = df, mapping = aes(x = x, y = y)) + geom_point(mapping = aes(color = 'red'))
p + Move_Legend("left")

}
\concept{themes}
