% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item_update.R
\name{item_update}
\alias{item_update}
\title{Update a SB item with new metadata}
\usage{
item_update(sb_id, info, ...)
}
\arguments{
\item{sb_id}{An \code{\link{sbitem}} object or a character ScienceBase ID corresponding to the item}

\item{info}{list of metadata info (key-value pairs) to change on the item}

\item{...}{Additional parameters are passed on to \code{\link[httr]{GET}}, \code{\link[httr]{POST}},
\code{\link[httr]{HEAD}}, \code{\link[httr]{PUT}}.}
}
\value{
An object of class \code{sbitem}
}
\description{
Updates metadata associated with a ScienceBase item based on 
supplied list of new or updated metadata elements.
}
\examples{
\dontrun{
res <- item_create(user_id(), "item-to-update") 
out <- item_update(res, list(title = "item-updated"))
out$title
}
}
