% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sazed.R
\name{aze}
\alias{aze}
\title{Compute the AZE component of the SAZED ensemble}
\usage{
aze(y, preprocess = T)
}
\arguments{
\item{y}{The input time series.}

\item{preprocess}{If true, y is detrended and z-normalized before
computation.}
}
\value{
The AZE season length estimate of y.
}
\description{
\code{aze} estimates the season length of its argument from the mean autocorrelation zero
distance
}
\examples{
season_length <- 26
y <- sin(1:400*2*pi/season_length)
aze(y)
aze(y, preprocess = FALSE)
}
