% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_sas.R
\name{run_sas}
\alias{run_sas}
\title{Run SAS code with SAS Session}
\usage{
run_sas(sas_code, results = c("TEXT", "HTML"), sas_session = get_sas_session())
}
\arguments{
\item{sas_code}{(\code{character})\cr sas code to be executed.}

\item{results}{(\code{character})\cr sas code execution results type.}

\item{sas_session}{(\code{saspy.sasbase.SASsession}) SAS session.}
}
\value{
Named list with following elements:
\itemize{
\item \code{LOG}: \code{string} of SAS execution log.
\item \code{LST}: \code{string} of SAS execution result, in html or txt format.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Run SAS code with a SAS session.
}
\details{
\code{run_sas} will run sas code through SAS session.
The results is a named list of \code{LST} and \code{LOG}.
The result part will be stored in \code{LST}, and log will be stored in \code{LOG}.
If \code{results} argument is "TEXT", then results are in text format;
if \code{results} argument is "HTML", then results are in html format.
}
