% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{extractMacroCalls}
\alias{extractMacroCalls}
\title{Extract macro calls from a string of SAS code}
\usage{
extractMacroCalls(sasCode, ignoreList = c("macro", "mend", "global", "let",
  "put", "if", "do", "end", "else"))
}
\arguments{
\item{sasCode}{SAS code}

\item{ignoreList}{Macro calls to ignore}
}
\value{
Vector of macro calls
}
\description{
Extract macro calls from a string of SAS code
}
\examples{
sasFile <- system.file('examples/SAScode/Macros/Util1.SAS', package='sasMap')
sasCode <- loadSAS(sasFile)
extractMacroCalls(sasCode)
}
