% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_policy.R
\name{compute_policy}
\alias{compute_policy}
\title{compute_policy}
\usage{
compute_policy(
  alpha,
  transition,
  observation,
  reward,
  state_prior = rep(1, dim(observation)[[1]])/dim(observation)[[1]],
  a_0 = 1
)
}
\arguments{
\item{alpha}{the matrix of alpha vectors returned by \code{\link{sarsop}}}

\item{transition}{Transition matrix, dimension n_s x n_s x n_a}

\item{observation}{Observation matrix, dimension n_s x n_z x n_a}

\item{reward}{reward matrix, dimension n_s x n_a}

\item{state_prior}{initial belief state, optional, defaults to uniform
over states}

\item{a_0}{previous action. Belief in state depends not only on observation, but on prior belief of the state and subsequent action that had been taken.}
}
\value{
a data frame providing the optimal policy (choice of action) and corresponding value of the action for each possible belief state
}
\description{
Derive the corresponding policy function from the alpha vectors
}
\examples{

m <- fisheries_matrices()
\donttest{ ## Takes > 5s
if(assert_has_appl()){
alpha <- sarsop(m$transition, m$observation, m$reward, 0.95, precision = 10)
compute_policy(alpha, m$transition, m$observation, m$reward)
}
}

}
