% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sar_countryside.R
\name{countryside_extrap}
\alias{countryside_extrap}
\title{Use a sar_countryside() model object to predict richness}
\usage{
countryside_extrap(fits, area)
}
\arguments{
\item{fits}{A fitted model object from \code{\link{sar_countryside}}.}

\item{area}{A vector of area values - the number (and order)
of area values (i.e., the length of the vector) must match
the number (and order) of habitats in the dataset used in
the \code{\link{sar_countryside}} fit.}
}
\value{
A list with three elements. The first contains the
  predicted richness values from the individual component
  models. The second contains the predicted total richness of
  the site (i.e., the summed component model predictions), and
  the third is a logical value highlighting whether there were
  any failed models in \code{fits}, i.e., component models
  that could not be fitted in \code{\link{sar_countryside}}.
}
\description{
Use a fitted model object from sar_countryside() 
to predict richness, given a set of habitat area values.
}
\details{
Takes a model fit generated using
  \code{\link{sar_countryside}} and uses it to predict
  richness values for a set of user-provided habitat
  \code{area} values. Note this can either be interpolated or
  extrapolated predictions, depending on the range of area
  values used in the original model fits.

  The habitat area values provided through \code{area} need to
  be in the same order as the habitat columns in the original
  dataset used in \code{\link{sar_countryside}}.
  
  The function does work with failed component model fits (any model fit that
  is NA is removed along with the corresponding area values provided by the
  user), as long as at least one component model was successfully fitted.
  However, arguably it does not make sense to predict richness values unless
  all component models were successfully fitted.
}
\examples{
\dontrun{
data(countryside)
#Fit the sar_countryside model (power version)
s3 <- sar_countryside(data = countryside, modType = "power",
gridStart = "partial", habNam = c("AG", "SH",
"F"), spNam = c("AG_Sp", "SH_Sp", "F_Sp", "UB_Sp"))
#Predict the richness of a site which comprises 1000 area units
#of agricultural land, 1000 of shrubland and 1000 of forest.
countryside_extrap(s3, area = c(1000, 1000, 1000))
}
}
\author{
Thomas J. Matthews
}
