% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/warpWindowSP.R
\name{warpWindowSP}
\alias{warpWindowSP}
\title{Restrict the DTW warping window for snow profiles alignment}
\usage{
warpWindowSP(
  iw,
  jw,
  iheight,
  jheight,
  iddate,
  jddate,
  profile.size,
  profile.height,
  window.size = 0.3,
  window.size.abs = NA,
  ddate.window.size = Inf,
  ...
)
}
\arguments{
\item{iw}{matrix of integers indicating their row number (cf., \code{?row})}

\item{jw}{matrix of integers indicating their column number (cf., \code{?col})}

\item{iheight}{matrix of query height filled into the columns of the matrix}

\item{jheight}{matrix of ref height filled into the rows of the matrix}

\item{iddate}{same as iheight, but containing deposition date information (i.e., POSIXct data converted to numeric through matrix call!)}

\item{jddate}{same as jheight, but containing deposition date information (i.e., POSIXct data converted to numeric through matrix call!)}

\item{profile.size}{number of layers in the longer one of the two profiles (scalar)}

\item{profile.height}{snow height of the deeper one of the two profiles (scalar)}

\item{window.size}{percentage of profile.size or profile.height defining the size of the warping window
(i.e., the most restrictive of the two will be applied)}

\item{window.size.abs}{Instead of a \code{window.size} percentage, an absolute value (in \emph{cm}!) can be provided}

\item{ddate.window.size}{number of days that exclude layers from the warping window if their deposition dates
differ by more than these days}

\item{...}{unused---but important to be able to provide other warping functions to \link{distMatSP}}
}
\description{
Given a matrix, this function sets all elements of the matrix that are outside the so-called warping
window to \code{NA}. The warping window is a slanted band of constant width around the main diagonal
(i.e., \emph{Sakoe-Chiba}-band), and it's size can be controlled with function arguments.
}
\seealso{
\link[dtw:dtwWindowingFunctions]{dtw::dtwWindowingFunctions}
}
