% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text.R
\name{embed_cat_text_html}
\alias{embed_cat_text_html}
\title{Creates a structured list with text interpretations for a set of variables.}
\usage{
embed_cat_text_html(
  data,
  dep = NULL,
  indep = NULL,
  ...,
  mesos_group = NULL,
  call = rlang::caller_env()
)
}
\arguments{
\item{data}{\emph{Survey data}

\verb{obj:<data.frame>|obj:<tbl_df>} // Required

A data frame (or a srvyr-object) with the columns specified in the
chapter_overview 'dep_cat', etc columns.}

\item{dep, indep}{\emph{Variable selections}

<\code{tidyselect}> // \emph{Default:} \code{NULL}, meaning everything for dep, nothing for indep.

Columns in \code{data}. Currently allows tidyselect-syntax, which will be removed.}

\item{...}{\emph{Dynamic dots}

<\href{https://rlang.r-lib.org/reference/dyn-dots.html}{\code{dynamic-dots}}>

Arguments forwarded to the corresponding functions that create the elements.}

\item{mesos_group}{\emph{Specific group to compare with}

\verb{scalar<character>} // \emph{Default:} \code{NULL} (\code{optional})

Both the absolute and relative folderpaths are required, as strings.}

\item{call}{\emph{Internal call}

\verb{obj:<call>} // \emph{Default:} \code{rlang::caller_env()} (\code{optional})

Both the absolute and relative folderpaths are required, as strings.}
}
\value{
List
}
\description{
Creates a structured list with text interpretations for a set of variables.
}
\examples{
embed_cat_text_html(ex_survey,
dep = tidyselect::matches("e_"),
contents = c("intro", "mode_max", "value_max",
"value_min", "not_used_category", "mean_max", "mean_min"),
label_separator = " - ",
require_common_categories = FALSE,
n_top_bottom = 1,
showNA = "never",
descend = TRUE,
return_raw = TRUE,
hide_label_if_prop_below=0,
data_label = "count",
data_label_decimal_symbol = ",",
digits = 1)

}
