% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tweet_acquire.R
\name{tweet_acquire}
\alias{tweet_acquire}
\title{Acquire Twitter Tweets}
\usage{
tweet_acquire(consumer_key, consumer_secret, access_token, access_secret,
  HT, num_tweets, file_name, distinct = TRUE)
}
\arguments{
\item{consumer_key}{Twitter Application management consumer key.}

\item{consumer_secret}{Twitter Application management consumer secret key.}

\item{access_token}{Twitter Application management access token.}

\item{access_secret}{Twitter Application management access secret key.}

\item{HT}{A single hashtag or a list of hashtags the user has specified.}

\item{num_tweets}{Number of Tweets to be acquired per each hashtag.}

\item{file_name}{User desired output .RData file name.}

\item{distinct}{Logical.  If distinct = TRUE, the function removes multiple Tweets that originate from the same Twitter id at the exact same time.}
}
\value{
A DataFrame.
}
\description{
Function will enable a user to access the Twitter API throught the 
[Twitter Developers Account](https://dev.twitter.com/) site.
Once a user has a Twitter developers account and has recieved their individual consumer key, 
consumer secret key, access token, and access secret they can 
acquire Tweets based on a list of hashtags and a requested number of entires per hashtag.
}
\examples{
\donttest{
consumer_key <- "XXXXXXXXXXXXXXXXXXXXXXXXX"
consumer_secret <- "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
access_token <- "XXXXXXXXXXXXXXXXXX-XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
access_secret <- "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"

test_tweets <- file.path(tempdir(), "test_tweets.RData")

hashtags <- c("#job", "#Friday", "#fail", "#icecream", "#random", "#kitten", "#airline")

tweet_acquire(consumer_key = consumer_key, 
              consumer_secret = consumer_secret, 
              access_token = access_token, 
              access_secret = access_secret, 
              HT = hashtags, 
              num_tweets = 10, 
              file_name = test_tweets,
              distinct = TRUE)
        
load(test_tweets)
}
}
