% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_Subsample.R
\name{prepare_Subsample}
\alias{prepare_Subsample}
\title{Prepare Subsamples from a Sample Dataset}
\usage{
prepare_Subsample(sample, number, volume, weight)
}
\arguments{
\item{sample}{\link{data.frame}, sample object to be distributed to
aliquots.}

\item{number}{\link{numeric} value, number of evenly large subsamples to
be created}

\item{volume}{\link{numeric} value, volume of subsamples. Remainder
of the master sample that is too small for the last subsample is
removed. Volume must be given in m^3 and takes packing density of
the sample into account.}

\item{weight}{\link{numeric} value, weight of the subsamples. Remainder
of the master sample that is too small for the last subsample is
removed. Weight is calculated based on density of each grain. Weight
must be given in kg.}
}
\value{
\link{list} object with grains organised as aliquots, i.e. list
elements.
}
\description{
The function splits the master sample in a set of subsamples. The
step can be done by creating equally large subsamples in terms of
contained grains (parameter \code{number}), by volume (parameter
\code{volume}) or by weight (parameter \code{weight}).
}
\examples{
## load example data set
data(sample, envir = environment())

## create 10 subsamples
prepare_Subsample(sample, 10) 

}
\author{
Michael Dietze, GFZ Postdam (Germany)
}
