% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Z_identities.R
\name{Bayesian_Sampler}
\alias{Bayesian_Sampler}
\title{Bayesian Sampler Model}
\usage{
Bayesian_Sampler(
  a_and_b,
  b_and_not_a,
  a_and_not_b,
  not_a_and_not_b,
  beta,
  N,
  N2 = NULL
)
}
\arguments{
\item{a_and_b, b_and_not_a, a_and_not_b, not_a_and_not_b}{True probabilites for the conjuctions and disjunctions of A and B. Must add to 1.}

\item{beta}{Prior parameter.}

\item{N}{Number of samples drawn}

\item{N2}{Optional. Number of samples drawn for conjunctions and disjunctions. (called N' in the paper). If not given, it will default to N2=N. Must be equal or smaller than N.}
}
\value{
Named list with predicted probabilities for every possible combination of A and B.
}
\description{
As described in \insertCite{zhu2020BayesianSamplerGeneric}{samplr}. Vectors can be provided for each parameter, allowing multiple estimates at once.
}
\examples{
Bayesian_Sampler(
    a_and_b = c(.4, .25),
    b_and_not_a = c(.4,  .25),
    a_and_not_b = c(.1, .25),
    not_a_and_not_b = c(.1, .25),
    beta = 1,
    N <- c(10, 12),
    N2 <- c(10, 10)
)
}
