% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srssamplesize.R
\name{srssamplesize}
\alias{srssamplesize}
\title{Simple Random Sample size.}
\usage{
srssamplesize(
  N,
  var,
  error,
  alpha,
  estimator = c("total", "mean", "proportion", "class total"),
  p,
  mean,
  replace = FALSE,
  relative = FALSE
)
}
\arguments{
\item{N}{Number of instances of the data set.}

\item{var}{Estimated quasivariance.}

\item{error}{Sampling error}

\item{alpha}{Significance level to obtain confidence intervals.}

\item{estimator}{One of "total", "proportion", "mean", "class total". Default is "total"}

\item{p}{Estimated proportion. If estimator is not "proportion" or "class total" it will be ignored.}

\item{mean}{Estimated mean. If relative=FALSE it will be ignored.}

\item{replace}{Whether the sample to be taken can have repeated instances or not.}

\item{relative}{Whether the specified error is relative or not.}
}
\value{
Number of instances of the sample to be taken.
}
\description{
Calculates the required sample size in order to achieve a relative
or absolute sampling error  less or equal to the specified for an specific
estimator and an optional confidence interval in simple random sampling.
}
\details{
If the sample size result is not a whole number the number returned is
the next whole number so srssamplesize>=n is satisfied.\cr
To estimate sample size of estimators "total" and "mean" estimated quasivariance
must be provided. If the error is relative then estimated mean must also be provided.\cr
To estimate sample size of estimator "proportion" and "class total" estimated
proportion must be provided. If p is not specified sample size will be estimated
based on worst-case scenario of p=0.5.\cr
N must be always be provided for calculations.
}
\examples{
data<-rnorm(200, 100, 20)
n<-srssamplesize(200, var(data), estimator="total", error=400);n
sample<-data[samplingR::srs(200, n)]
samplingR::srsestimator(200, sample, "total", alpha=0.05)$sampling.error


}
