% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srsestimator.R
\name{srsestimator}
\alias{srsestimator}
\title{Simple Ramdom Sampling estimator}
\usage{
srsestimator(N, data, estimator, alpha = 0.05)
}
\arguments{
\item{N}{Size of the total data set.}

\item{data}{Sample of the data. It must only contain a single column of the
data to estimate.}

\item{estimator}{One of "total", "mean".}

\item{alpha}{Optional value to determine the estimation error and build 1-alpha
confidence interval of the estimator.}
}
\value{
A list containing different interest values:
\itemize{
\item estimator
\item variance
\item sampling.error
\item estimation.error
\item confint
}
}
\description{
Function to make estimations of diferent parameters based on
a Simple Random Sample.
}
\examples{
data<-rnorm(200, 100, 20)
sample<-data[samplingR::srs(200, 50)]
tau<-sum(data);tau
srsestimator(200, sample, "total", 0.05)

}
