% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssampcalc.R
\name{ssampcalc}
\alias{ssampcalc}
\title{Determines sample size by strata using proportional allocation}
\usage{
ssampcalc(df, n, strata, over = 0)
}
\arguments{
\item{df}{object containing sampling data frame (e.g. data)}

\item{n}{sample size (integer) or object containing sample size}

\item{strata}{variable in sampling data frame by which to stratify (e.g. region)}

\item{over}{(optional) desired oversampling proportion (defaults to 0; takes value between 0 and 1 as input)}
}
\value{
Returns proportional sample size per strata (rounded up to nearest integer)
}
\description{
Determines sample size by strata using proportional allocation
}
\examples{
ssampcalc(df=albania, n=544, strata=qarku, over=0.05)

size <- rsampcalc(nrow(albania), 3, 95, 0.5)
ssampcalc(albania, size, qarku)
}
\references{
[1] Sampling Design & Analysis, S. Lohr, 1999, 4.4
}
