% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spro.R
\name{spro}
\alias{spro}
\title{Calculate proportion and margin of error (stratified sample)}
\usage{
spro(fulldf, sampdf, strata, col_name, ci = 95, na = "")
}
\arguments{
\item{fulldf}{object containing original data frame used to draw sample}

\item{sampdf}{object containing data frame on which to perform analysis}

\item{strata}{variable in both data frames by which to stratify}

\item{col_name}{variable in data frame for which you want to calculate proportion and margin of error}

\item{ci}{(optional) confidence level for establishing a confidence interval using z-score (defaults to 95; restricted to 80, 85, 90, 95 or 99 as input)}

\item{na}{(optional) value that you want to filter and exclude (defaults to include everything)}
}
\value{
Returns table of responses (n), proportions, margins of error, lower and upper bounds by factor for a given variable in a stratified sample
}
\description{
Calculate proportion and margin of error (stratified sample)
}
\examples{
spro(fulldf=albania, sampdf=opening, strata=qarku, col_name=openTime, ci=95, na="n/a")
}
\references{
[1] Sampling Design & Analysis, S. Lohr, 1999, 4.6 & 4.7
}
