% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samc-class.R
\docType{class}
\name{samc-class}
\alias{samc-class}
\title{samc class}
\description{
S4 class to manage SAMC data.
}
\details{
The samc class is used to help ensure that the package is used correctly and
to minimize the possibility for users to accidentally produce nonsensical
results that may not be obviously incorrect. This class contains the p matrix
necessary for all the calculations in the package, and enforces its type so
that users are less likely to inadvertently alter it in a way that will cause
issues in calculations.

The class also contains a RasterLayer object derived from the input data.
This object is used for checking inputs and mapping vector data in other
functions.

Finally, an override flag is used to help ensure that users do not
accidentally run memory intensive versions of functions that can cause their
systems to become non-responsive or for software to crash.

The \code{\link{samc}} function is used to create \code{\link{samc-class}}
objects.
}
\section{Slots}{

\describe{
\item{\code{p}}{The transition probability matrix \emph{P}.}

\item{\code{source}}{Information about the data source for the P matrix}

\item{\code{map}}{Used to verify landscape inputs and mapping of vector data.}

\item{\code{override}}{Used to prevent accidental use of memory intensive functions.}
}}

