% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mortality.R
\docType{methods}
\name{mortality}
\alias{mortality}
\alias{mortality,samc,missing,missing,missing,numeric-method}
\alias{mortality,samc,missing,numeric,missing,numeric-method}
\alias{mortality,samc,missing,missing,numeric,numeric-method}
\alias{mortality,samc,missing,numeric,numeric,numeric-method}
\alias{mortality,samc,RasterLayer,missing,missing,numeric-method}
\alias{mortality,samc,matrix,missing,missing,numeric-method}
\alias{mortality,samc,missing,missing,missing,missing-method}
\alias{mortality,samc,missing,numeric,missing,missing-method}
\alias{mortality,samc,missing,missing,numeric,missing-method}
\alias{mortality,samc,missing,numeric,numeric,missing-method}
\alias{mortality,samc,RasterLayer,missing,missing,missing-method}
\alias{mortality,samc,matrix,missing,missing,missing-method}
\title{Calculate mortality metrics}
\usage{
mortality(samc, occ, origin, dest, time)

\S4method{mortality}{samc,missing,missing,missing,numeric}(samc, time)

\S4method{mortality}{samc,missing,numeric,missing,numeric}(samc, origin,
  time)

\S4method{mortality}{samc,missing,missing,numeric,numeric}(samc, dest,
  time)

\S4method{mortality}{samc,missing,numeric,numeric,numeric}(samc, origin,
  dest, time)

\S4method{mortality}{samc,RasterLayer,missing,missing,numeric}(samc, occ,
  time)

\S4method{mortality}{samc,matrix,missing,missing,numeric}(samc, occ, time)

\S4method{mortality}{samc,missing,missing,missing,missing}(samc)

\S4method{mortality}{samc,missing,numeric,missing,missing}(samc, origin)

\S4method{mortality}{samc,missing,missing,numeric,missing}(samc, dest)

\S4method{mortality}{samc,missing,numeric,numeric,missing}(samc, origin,
  dest)

\S4method{mortality}{samc,RasterLayer,missing,missing,missing}(samc, occ)

\S4method{mortality}{samc,matrix,missing,missing,missing}(samc, occ)
}
\arguments{
\item{samc}{A \code{\link{samc-class}} object. This should be output from
the \code{\link{samc}} function.}

\item{occ}{A \code{\link[raster]{RasterLayer-class}} or \code{\link[base]{matrix}}.
The input type must match the input type used to create the
\code{\link{samc-class}} object, and must have the same properties as the
rest of the landscape data. See the \code{\link{check}} function for more
details.}

\item{origin}{A positive integer representing a cell in the landscape,
excluding \code{NA} cells. Corresponds to row \emph{i} of matrix \emph{P}
in the \code{\link{samc-class}} object.}

\item{dest}{A positive integer representing a cell in the landscape,
excluding \code{NA} cells. Corresponds to column \emph{j} of matrix \emph{P}
in the \code{\link{samc-class}} object.}

\item{time}{A positive integer representing time steps}
}
\value{
A matrix, vector, or numeric
}
\description{
Calculates the probability of experiencing mortality at specific locations.
}
\details{
\eqn{\tilde{B}_t = (\sum_{n=0}^{t-1} Q^n) \tilde{R}}
\itemize{
  \item \strong{mortality(samc, time)}

The result is a matrix where element (i,j) is the probability of experiencing
mortality at location j within t or fewer steps if starting at location i.

The returned matrix will always be dense and cannot be optimized. Must enable
override to use.

\item \strong{mortality(samc, origin, time)}

The result is a vector where each element corresponds to a cell in the
landscape, and can be mapped back to the landscape using the
\code{\link{map}} function. Element j is the probability of experiencing
mortality at location j within t or fewer steps if starting at a given origin.

\item \strong{mortality(samc, dest, time)}

The result is a vector where each element corresponds to a cell in the
landscape, and can be mapped back to the landscape using the
\code{\link{map}} function. Element i is the probability of experiencing
mortality at a given destination within t or fewer steps if starting at
location i.

\item \strong{mortality(samc, origin, dest, time)}

The result is a numeric value that is the probability of experiencing
mortality at a given destination within t or fewer steps if starting at a
given origin.
}

\eqn{\psi^T \tilde{B}_t}
\itemize{
  \item \strong{mortality(samc, occ, time)}

The result is a vector where each element corresponds to a cell in the
landscape, and can be mapped back to the landscape using the
\code{\link{map}} function. Element j is the unconditional probability of
experiencing mortality at location j within t or fewer time steps.
}

\eqn{B = F \tilde{R}}
\itemize{
  \item \strong{mortality(samc)}

The result is a matrix where element (i,j) is the probability of experiencing
mortality at location j if starting at location i.

The returned matrix will always be dense and cannot be optimized. Must enable
override to use.

\item \strong{mortality(samc, origin)}

The result is a vector where each element corresponds to a cell in the
landscape, and can be mapped back to the landscape using the
\code{\link{map}} function. Element j is the probability of experiencing
mortality at location j if starting at a given origin.

\item \strong{mortality(samc, dest)}

The result is a vector where each element corresponds to a cell in the
landscape, and can be mapped back to the landscape using the
\code{\link{map}} function. Element i is the probability of experiencing
mortality at a given destination if starting at location i.

\item \strong{mortality(samc, origin, dest)}

The result is a numeric value that is the probability of experiencing
mortality at a given destination if starting at a given origin
}

\eqn{\psi^T B}
\itemize{
  \item \strong{mortality(samc, occ)}

The result is a vector where each element corresponds to a cell in the
landscape, and can be mapped back to the landscape using the
\code{\link{map}} function. Element j is the unconditional probability of
experiencing mortality at location j, regardless of the initial state.
}
}
\section{Performance}{


Any relevant performance information about this function can be found in the
performance vignette: \href{../doc/performance.html}{\code{vignette("performance", package = "samc")}}
}

\examples{
# "Load" the data. In this case we are using data built into the package.
# In practice, users will likely load raster data using the raster() function
# from the raster package.
res_data <- samc::ex_res_data
abs_data <- samc::ex_abs_data
occ_data <- samc::ex_occ_data


# Make sure our data meets the basic input requirements of the package using
# the check() function.
check(res_data, abs_data)
check(res_data, occ_data)


# Create a `samc-class` object with the resistance and absorption data using
# the samc() function. We use the recipricol of the arithmetic mean for
# calculating the transition matrix. Note, the input data here are matrices,
# not RasterLayers. If using RasterLayers, the latlon parameter must be set.
samc_obj <- samc(res_data, abs_data, tr_fun = function(x) 1/mean(x))


# Convert the occupancy data to probability of occurrence
occ_prob_data <- occ_data / sum(occ_data, na.rm = TRUE)


# Calculate short- and long-term metrics using the analytical functions
short_mort <- mortality(samc_obj, occ_prob_data, time = 50)
short_dist <- distribution(samc_obj, origin = 3, time = 50)
long_disp <- dispersal(samc_obj, occ_prob_data)
visit <- visitation(samc_obj, dest = 4)
surv <- survival(samc_obj)


# Use the map() function to turn vector results into RasterLayer objects.
short_mort_map <- map(samc_obj, short_mort)
short_dist_map <- map(samc_obj, short_dist)
long_disp_map <- map(samc_obj, long_disp)
visit_map <- map(samc_obj, visit)
surv_map <- map(samc_obj, surv)
}
